#include "StdAfx.h"
#include <windows.h>
#include <Winioctl.h>
#include <windows.h>
#include <initguid.h>   // Guid definition
#include <devguid.h>    // Device guids
#include <setupapi.h>   // for SetupDiXxx functions.
#include ".\changercontrol.h"

CChangerControl::CChangerControl(void)
{
	m_pszChangerPath = NULL;
	m_hChanger = INVALID_HANDLE_VALUE;
}

CChangerControl::~CChangerControl(void)
{
	if (m_pszChangerPath != NULL) 
	{
		delete m_pszChangerPath;
		m_pszChangerPath = NULL;
	}

	if (m_hChanger != INVALID_HANDLE_VALUE)
	{
		CloseHandle(m_hChanger);
		m_hChanger = INVALID_HANDLE_VALUE;
	}
}

HRESULT CChangerControl::Init(void)
{
	HRESULT hr = S_OK;

	// get the path to the changer
	hr = this->FindChangerPath();
	if (FAILED(hr)) return hr;

	// open the changer
	hr = this->OpenChanger();
	if (FAILED(hr)) return hr;

	return hr;
}

HRESULT CChangerControl::FindChangerPath(void)
{
    HDEVINFO hDevInfo;;
	BOOL status;
	HRESULT hr = E_FAIL;
	SP_DEVICE_INTERFACE_DETAIL_DATA *pDeviceInterfaceDetailData = NULL;

	// get the list of devices that have our interface
    hDevInfo = SetupDiGetClassDevs(
					(LPGUID) &GUID_DEVINTERFACE_MEDIUMCHANGER,
                    NULL,
                    NULL, 
                    DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
    if (hDevInfo == INVALID_HANDLE_VALUE)
    {
		hr = HRESULT_FROM_WIN32(GetLastError());
        goto error;
    }

	// we're going to use the find changer that we find.  If you own multiple
	// changers then feel free to update this code.

	// enumerate the first device
	SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
	ZeroMemory(&deviceInterfaceData, sizeof(SP_DEVICE_INTERFACE_DATA));
	deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);
	status = SetupDiEnumDeviceInterfaces(
		hDevInfo,
		NULL,
		(LPGUID) &GUID_DEVINTERFACE_MEDIUMCHANGER,
		0,
		&deviceInterfaceData);
	if (status == FALSE)
	{
		hr = HRESULT_FROM_WIN32(GetLastError());
		goto error;
	}

	// get the detail data.  Note that we really should call this twice to use the
	// right size path.  For now we just allocate 1024 bytes.
	DWORD cbDeviceInterfaceDetailData = 1024;
	pDeviceInterfaceDetailData = (SP_DEVICE_INTERFACE_DETAIL_DATA *) new BYTE[1024];
	pDeviceInterfaceDetailData->cbSize = sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

	status = SetupDiGetDeviceInterfaceDetail(
		hDevInfo,
		&deviceInterfaceData,
		pDeviceInterfaceDetailData,
		cbDeviceInterfaceDetailData,
		&cbDeviceInterfaceDetailData,
		NULL);
	if (status == FALSE)
	{
		hr = HRESULT_FROM_WIN32(GetLastError());
		goto error;
	}

	// pDeviceInterfaceDetailData now contains our device path, copy it out.
	m_pszChangerPath = new char[strlen(pDeviceInterfaceDetailData->DevicePath) + 1];
	strcpy(
		m_pszChangerPath,
		pDeviceInterfaceDetailData->DevicePath);
	hr = S_OK;

error:
	if (hDevInfo != NULL)
	{
		SetupDiDestroyDeviceInfoList(hDevInfo);
	}
	if (pDeviceInterfaceDetailData != NULL)
	{
		delete pDeviceInterfaceDetailData;
	}

    return hr;
}

HRESULT CChangerControl::OpenChanger()
{
	m_hChanger = CreateFile(
		m_pszChangerPath,
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		0,
		NULL);
	if (m_hChanger == INVALID_HANDLE_VALUE)
	{
		return HRESULT_FROM_WIN32(GetLastError());
	}

	return S_OK;
}

HRESULT CChangerControl::PrintStatus()
{
	BOOL status;
	DWORD bytesReturned;
	CHANGER_PRODUCT_DATA changerProductData;
	HRESULT hr;

	status = DeviceIoControl(
		m_hChanger,
		IOCTL_CHANGER_GET_PRODUCT_DATA,
		NULL,
		0,
		&changerProductData,
		sizeof(changerProductData),
		&bytesReturned,
		NULL);
	if (status == false)
	{
		hr = HRESULT_FROM_WIN32(GetLastError());
		return hr;
	}

	printf("vendor = %s\n", changerProductData.VendorId);
	printf("status = %lu", status);

	return S_OK;
}

HRESULT CChangerControl::IsSlotFull(DWORD elementAddress)
{
	BOOL status;
	DWORD bytesReturned;
	HRESULT hr;

	CHANGER_READ_ELEMENT_STATUS changerReadElementStatus;
	changerReadElementStatus.ElementList.Element.ElementAddress = elementAddress;
	changerReadElementStatus.ElementList.Element.ElementType = ChangerSlot;
	changerReadElementStatus.ElementList.NumberOfElements = 1;
	changerReadElementStatus.VolumeTagInfo = FALSE;
	CHANGER_ELEMENT_STATUS elementStatus;

	status = DeviceIoControl(
		m_hChanger,
		IOCTL_CHANGER_GET_ELEMENT_STATUS,
		&changerReadElementStatus,
		sizeof(changerReadElementStatus),
		&elementStatus,
		sizeof(elementStatus),
		&bytesReturned,
		NULL);
	if (status == false)
	{
		hr = HRESULT_FROM_WIN32(GetLastError());
		return hr;
	}

	return (elementStatus.Flags & ELEMENT_STATUS_FULL) ? S_OK : S_FALSE;
}

HRESULT CChangerControl::GetDriveStatus(BOOL *pfDriveFull, int *piSourceAddress)
{
	BOOL status;
	DWORD bytesReturned;
	HRESULT hr;
	BOOL fFull;

	CHANGER_READ_ELEMENT_STATUS changerReadElementStatus;
	changerReadElementStatus.ElementList.Element.ElementAddress = 0;
	changerReadElementStatus.ElementList.Element.ElementType = ChangerDrive;
	changerReadElementStatus.ElementList.NumberOfElements = 1;
	changerReadElementStatus.VolumeTagInfo = FALSE;
	CHANGER_ELEMENT_STATUS elementStatus;

	status = DeviceIoControl(
		m_hChanger,
		IOCTL_CHANGER_GET_ELEMENT_STATUS,
		&changerReadElementStatus,
		sizeof(changerReadElementStatus),
		&elementStatus,
		sizeof(elementStatus),
		&bytesReturned,
		NULL);
	if (status == false)
	{
		hr = HRESULT_FROM_WIN32(GetLastError());
		return hr;
	}

	fFull = ((elementStatus.Flags & ELEMENT_STATUS_FULL) == ELEMENT_STATUS_FULL);
	if (pfDriveFull) 
		*pfDriveFull = fFull;
	if (piSourceAddress)
		*piSourceAddress = (fFull) ? elementStatus.SrcElementAddress.ElementAddress : -1;

	return (elementStatus.Flags & ELEMENT_STATUS_FULL) ? S_OK : S_FALSE;
}

HRESULT CChangerControl::MoveMedium(
	ELEMENT_TYPE sourceElementType,
	DWORD sourceElementAddress,
	ELEMENT_TYPE destinationElementType,
	DWORD destinationElementAddress)
{
	BOOL status;
	DWORD bytesReturned;
	HRESULT hr;

	CHANGER_MOVE_MEDIUM changerMoveMedium;
	changerMoveMedium.Source.ElementAddress = sourceElementAddress;
	changerMoveMedium.Source.ElementType = sourceElementType;
	changerMoveMedium.Destination.ElementAddress = destinationElementAddress;
	changerMoveMedium.Destination.ElementType = destinationElementType;
	changerMoveMedium.Flip = FALSE;
	changerMoveMedium.Transport.ElementAddress = 0;
	changerMoveMedium.Transport.ElementType = ChangerTransport;

	status = DeviceIoControl(
		m_hChanger,
		IOCTL_CHANGER_MOVE_MEDIUM,
		&changerMoveMedium,
		sizeof(changerMoveMedium),
		NULL,
		0,
		&bytesReturned,
		NULL);
	if (status == false)
	{
		hr = HRESULT_FROM_WIN32(GetLastError());
		return hr;
	}

	return S_OK;
}

