#pragma once

#include <windows.h>

class CChangerControl
{
public:
	CChangerControl(void);
	~CChangerControl(void);

	HRESULT Init(void);

	HRESULT PrintStatus(void);
	HRESULT IsSlotFull(DWORD elementAddress);
	HRESULT GetDriveStatus(BOOL *pfDriveFull = NULL, int *piSourceSlot = NULL);
	HRESULT MoveMedium(
		ELEMENT_TYPE sourceElementType,
		DWORD sourceElementAddress,
		ELEMENT_TYPE destinationElementType,
		DWORD destinationElementAddress);


private:
	HRESULT FindChangerPath();

	HRESULT OpenChanger();

	char *m_pszChangerPath;
	HANDLE m_hChanger;
};

/*
// ce5939ae-ebde-11d0-b181-0000f8753ec4
DEFINE_GUID(GUID_DEVINTERFACE_SONYCHANGER,          
			0xce5939aeL, 0xebde, 0x11d0, 0xb1, 0x81, 0x00, 0x00, 0xf8, 0x75, 0x3e, 0xc4);
*/
